// Voeg deze constante toe om archetype, description, en pillars te gebruiken in de POST body.
// Je kunt deze waarden aanpassen aan je specifieke toepassing.
const archetype = "Ally";  // Pas dit aan naar het gewenste archetype
const description = "At Donghua International, we are committed to driving excellence and innovation in the field of mechanical drive systems. Our reputation as a leading provider of premium chain solutions is built on a foundation of quality, expertise, and a customer-centric approach. Whether working with OEMs (Original Equipment Manufacturers) or MRO (Maintenance, Repair, and Overhaul) partners, we strive to deliver exceptional value through tailored solutions and cutting-edge technology. Research and development across the entire Donghua Chain Group yields circa 800 product innovations per year. We conduct research into the use of materials, composition, post-processing, finishing and, of course, the long-term consequences of these choices. Donghua International plays a crucial role for distribution- and MRO-partners by enhancing their chain system expertise through comprehensive training courses, keeping them updated with the latest chain technology developments. This training equips partners to adeptly manage intricate chain systems and offer specialized solutions.\n\nAdditionally, we supply custom specialty products, developed with our engineering team, enabling distributors and MROs to become regional specialists. Our extensive product range, which includes 12,000 variants across six series, is exclusively available through our selected distribution- and MRO-partners, ensuring high-quality solutions for end users.";  // Pas aan met de beschrijving van het bedrijf
const pillars = "Chain Manufacturer,Drive Chains,Conveyor Chains,Application Chains,Leaf Chains,Agriculture Chains,Chain Drive Components";  // Content pillars van het bedrijf

// Functie om te controleren of we op een WordPress editor-pagina zijn
function isWordPressEditorPage() {
    return document.body.classList.contains('wp-admin') &&
           (document.body.classList.contains('post-php') ||
            document.body.classList.contains('post-new-php') ||
            document.body.classList.contains('page-php') ||
            document.body.classList.contains('page-new-php'));
}

// Functie om te controleren of WPML is geactiveerd
function isWPMLActive() {
    return document.getElementById('icl_div') !== null
}

// Functie om de huidige WPML taal op te halen
function getCurrentWPMLLanguage() {
    const wpmlLangSelect = document.getElementById('icl_post_language');
    if (wpmlLangSelect) {
        return wpmlLangSelect.value || 'nl';
    }
    // Fallback naar Nederlands als de taal niet kan worden bepaald
    console.log('WPML taal niet gevonden, gebruik standaard "nl"');
    return 'nl';
}

// Hoofdfunctie om het script te initialiseren
function initTranslationScript() {
    if (!isWordPressEditorPage() || !isWPMLActive()) {
        console.log('Niet op een WordPress editor-pagina of WPML is niet geactiveerd. Script wordt niet uitgevoerd.');
        return;
    }

    console.log('WordPress editor-pagina gedetecteerd en WPML is actief. Script wordt geïnitialiseerd.');

    // Hier komt de rest van uw bestaande code, inclusief de getCurrentWPMLLanguage functie

    // Functie om de inhoud van een veld op te halen
    function getFieldContent(field) {
        if (field.classList.contains('wp-editor-area')) {
            console.log('WYSIWYG inhoud:', field.value);
            return field.value;
        } else {
            console.log('Input veld inhoud:', field.value);
            return field.value;
        }
    }

    // Functie om de inhoud van een veld in te stellen
    function setFieldContent(field, content) {
        field.value = content;
        console.log('Nieuwe inhoud ingesteld voor veld:', field.id);
    }

    // Functie om de vertaalknop toe te voegen aan een WYSIWYG-editor
    function addTranslateButtonToWysiwyg(editorWrap) {
        const toolbar = editorWrap.querySelector('.wp-editor-tools');
        if (toolbar) {
            const existingButton = toolbar.querySelector('button[data-action="translate"]');
            if (existingButton) {
                return; // Voorkom dubbele knoppen
            }

            const translateButton = document.createElement('button');
            translateButton.textContent = 'Vertalen';
            translateButton.type = 'button';
            translateButton.dataset.action = 'translate';
            translateButton.style.position = 'absolute';
            translateButton.style.zIndex = '999';
            translateButton.style.right = '0';
            translateButton.style.lineHeight = '24px';

            const editorId = editorWrap.querySelector('.wp-editor-area').id;
            translateButton.dataset.editorId = editorId;

            const loadingIndicator = document.createElement('span');
            loadingIndicator.textContent = 'Bezig met vertalen...';
            loadingIndicator.style.display = 'none';
            loadingIndicator.style.marginLeft = '10px';

            toolbar.appendChild(translateButton);
            toolbar.appendChild(loadingIndicator);

            console.log('Vertaalknop toegevoegd aan WYSIWYG editor:', editorId);

            // Voeg direct een click event listener toe
            translateButton.addEventListener('click', function(event) {
                console.log('WYSIWYG vertaalknop geklikt voor editor:', editorId);
                handleTranslateClick(event);
            });
        }
    }

    // Functie om de vertaalknop toe te voegen aan een normaal inputveld
    function addTranslateButtonToInput(field) {
        const existingButton = field.nextElementSibling;
        if (existingButton && existingButton.dataset.action === 'translate') {
            return; // Voorkom dubbele knoppen
        }

        const translateButton = document.createElement('button');
        translateButton.textContent = 'Vertalen';
        translateButton.style.marginLeft = '10px';
        translateButton.type = 'button';
        translateButton.dataset.action = 'translate';

        const loadingIndicator = document.createElement('span');
        loadingIndicator.textContent = 'Bezig met vertalen...';
        loadingIndicator.style.display = 'none';
        loadingIndicator.style.marginLeft = '10px';

        field.parentNode.insertBefore(translateButton, field.nextSibling);
        field.parentNode.insertBefore(loadingIndicator, translateButton.nextSibling);

        translateButton.addEventListener('click', handleTranslateClick);
    }

    function handleTranslateClick(event) {
        event.preventDefault();
        const button = event.target;
        let field;

        if (button.dataset.editorId) {
            // Voor WYSIWYG-editors
            field = document.getElementById(button.dataset.editorId);
        } else {
            // Voor normale inputvelden
            field = button.previousElementSibling;
        }

        console.log('Vertalen voor veld:', field.id);

        const textToTranslate = getFieldContent(field);
        if (!textToTranslate.trim()) {
            console.log('Geen tekst om te vertalen');
            alert('Er is geen tekst om te vertalen.');
            return;
        }

        const targetLang = getCurrentWPMLLanguage();
        const loadingIndicator = button.nextElementSibling;
        loadingIndicator.style.display = 'inline';
        button.disabled = true;

        // Verstuur vertaalverzoek naar de server
        fetch('https://merkelijkheid.network/translate.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                text: textToTranslate,
                targetLanguage: targetLang,
                archetype: archetype,
                description: description,
                pillars: pillars
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.translatedText) {
                setFieldContent(field, data.translatedText);
            } else {
                console.error('Vertaalfout:', data.error || 'Onbekende fout');
                alert('Vertaling mislukt: ' + (data.error || 'Onbekende fout'));
            }
        })
        .catch((error) => {
            console.error('Vertaalfout:', error);
            alert('Vertaling mislukt: ' + error.message);
        })
        .finally(() => {
            loadingIndicator.style.display = 'none';
            button.disabled = false;
        });
    }

    // Voeg vertaalknoppen toe aan alle WYSIWYG-editors en normale inputvelden
    function addTranslateButtons() {
        document.querySelectorAll('.acf-editor-wrap').forEach(addTranslateButtonToWysiwyg);
        document.querySelectorAll('input[type="text"], textarea:not(.wp-editor-area)').forEach(addTranslateButtonToInput);
    }

    // Voer de functie uit wanneer de pagina geladen is
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', addTranslateButtons);
    } else {
        addTranslateButtons();
    }

    // Voeg een MutationObserver toe om nieuwe velden te detecteren
    const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
            if (mutation.type === 'childList') {
                mutation.addedNodes.forEach((node) => {
                    if (node.nodeType === Node.ELEMENT_NODE) {
                        if (node.classList.contains('acf-editor-wrap')) {
                            addTranslateButtonToWysiwyg(node);
                        } else if (node.matches('input[type="text"], textarea:not(.wp-editor-area)')) {
                            addTranslateButtonToInput(node);
                        } else {
                            node.querySelectorAll('.acf-editor-wrap').forEach(addTranslateButtonToWysiwyg);
                            node.querySelectorAll('input[type="text"], textarea:not(.wp-editor-area)').forEach(addTranslateButtonToInput);
                        }
                    }
                });
            }
        });
    });

    observer.observe(document.body, { childList: true, subtree: true });

    // Voeg een globale click event listener toe
    document.addEventListener('click', function(event) {
        if (event.target.matches('button[data-action="translate"]')) {
            console.log('Globale click event gedetecteerd op vertaalknop');
            handleTranslateClick(event);
        }
    });
}

// Start het script
initTranslationScript();
